#include "stdafx.h"  // Need this to use precompiled headers.
#include "circle.h"

bool touching(const Circle &c1, const Circle &c2) {
    double distance = sqrt(
        pow(c1.centerX - c2.centerX, 2) + 
        pow(c1.centerY - c2.centerY, 2)
    );
    return distance <= c1.radius + c2.radius;
}

void Circle::draw(CDC &dc) {
    dc.Ellipse(
        int(centerX-radius+0.5), int(centerY-radius+0.5),
        int(centerX+radius+0.5), int(centerY+radius+0.5));
}

void Circle::erase(CDC &dc) {
    CPen whitePen(0,1,RGB(255,255,255));
    CPen * oldPenPtr = dc.SelectObject(&whitePen);
    draw(dc);
    dc.SelectObject(oldPenPtr);
}

const double Circle::pi = 4*atan(1.0);
